/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.skill.IClickableSkill;
import dev.toma.gunsrpg.api.common.skill.ICooldown;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.IIntervalProvider;
import dev.toma.gunsrpg.util.Interval;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;

public class LikeACatSkill
extends SimpleSkill
implements ICooldown,
IClickableSkill,
IDescriptionProvider {
    private final DescriptionContainer container;
    private final int effectLength;
    private final int totalCooldown;
    private int effectLeft;
    private int cooldown;

    public LikeACatSkill(SkillType<?> type, IIntervalProvider totalCooldown, IIntervalProvider effectLength) {
        super(type);
        this.effectLength = effectLength.getTicks();
        this.totalCooldown = totalCooldown.getTicks() + this.effectLength;
        this.container = new DescriptionContainer(type);
        this.container.addProperty("effect", Interval.format(this.effectLength, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE, Interval.Unit.SECOND)));
        this.container.addProperty("cooldown", Interval.format(this.totalCooldown, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE, Interval.Unit.SECOND)));
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    @Override
    public boolean canApply(PlayerEntity user) {
        return this.effectLeft == 0 && this.cooldown == 0;
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        if (this.effectLeft > 0) {
            --this.effectLeft;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public int getMaxCooldown() {
        return this.totalCooldown;
    }

    @Override
    public void setOnCooldown() {
        this.cooldown = this.totalCooldown;
    }

    @Override
    public void onUse(PlayerEntity player) {
    }

    @Override
    public boolean canUse() {
        return this.cooldown == 0;
    }

    @Override
    public void onSkillUsed(ServerPlayerEntity player) {
        this.effectLeft = this.effectLength;
        this.setOnCooldown();
        IPlayerData data = PlayerData.getUnsafe((PlayerEntity)player);
        IAttributeProvider provider = data.getAttributes();
        int effectDuration = (int)((double)this.effectLength * provider.getAttributeValue(Attribs.LIKE_A_CAT_EFFECT));
        player.func_195064_c(new EffectInstance(Effects.field_76439_r, effectDuration, 0, false, false));
        data.sync(2);
    }

    @Override
    public CompoundNBT saveData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("effect", this.effectLeft);
        nbt.func_74768_a("cooldown", this.cooldown);
        return nbt;
    }

    @Override
    public void readData(CompoundNBT nbt) {
        this.effectLeft = nbt.func_74762_e("effect");
        this.cooldown = nbt.func_74762_e("cooldown");
    }
}

